import eurostat

# Created 6/03/2025, Copyright (c) 2025 by G. Stamatelatos

""" Lets say we want to get data from Eurostat
    about how many tourists visited Greece in 2023"""



# Fetch the dataset
tourism_data = eurostat.get_data_df('tour_occ_nim')

# Filter for Greece (geo code: EL)
greece_data = tourism_data[tourism_data['geo\\TIME_PERIOD'] == 'EL']

# Check if data for Greece exists
if greece_data.empty:
    print("No data found for Greece.")
else:
    # Extract columns for the year 2023
    columns_2023 = [col for col in greece_data.columns if col.startswith('2023')]

    # Sum the values for 2023
    total_tourists_2023 = greece_data[columns_2023].sum().sum()

    print(f"Total tourists who visited Greece in 2023: {total_tourists_2023}")